/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xperfseq.h
 *       performance sequencer functions
 * -----------------------------------------------------------------*/

#ifndef XPERFSEQ_H_INCLUDED
#define XPERFSEQ_H_INCLUDED

#include <xperfdef.h>

#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************
  Generic properties ********************************************************
****************************************************************************/

CLI bx_errtype EXPORT BestXPerfGenSet(      /* @perfgenset  */
  bx_handletype handle,
  bx_int32 meas,                       
  bx_perfgentype prop,             
  bx_int32 val               
);

CLI bx_errtype EXPORT BestXPerfGenGet(      /* @perfgenget  */
  bx_handletype handle,
  bx_int32 meas,                        
  bx_perfgentype prop,           
  bx_int32 *val                                /*  #RETURN  "0x%08lx" */
);

CLI bx_errtype EXPORT BestXPerfGenDefaultSet(  /* @perfgendefset  */
  bx_handletype handle,
  bx_int32 meas                           
);

/****************************************************************************
  TRAN properties ********************************************************
****************************************************************************/

CLI bx_errtype EXPORT BestXPerfTranSet(     /* @perftranset    */
  bx_handletype handle,
  bx_int32 meas,                            
  bx_int32 offset, 
  bx_perftrantype prop,                   
  bx_int32 val                           
);

CLI bx_errtype EXPORT BestXPerfTranGet(     /* @perftranget */
  bx_handletype handle,
  bx_int32 meas,                  
  bx_int32 offset,
  bx_perftrantype prop,   
  bx_int32 *val                             /*  #RETURN  "0x%08lx" */
);

CLI bx_errtype EXPORT BestXPerfTranDefaultSet(     /* @perftrandefset    */
  bx_handletype handle,
  bx_int32 meas,                                  
  bx_int32 offset                               
);

/****************************************************************************
  COND properties ********************************************************
****************************************************************************/

CLI bx_errtype EXPORT BestXPerfCondSet( /* @perfcondset */
  bx_handletype handle,
  bx_int32 meas,    
  bx_int32 offset,                        
  bx_perfcondtype prop, 
  bx_charptrtype cond
);

CLI bx_errtype EXPORT BestXPerfCondGet( /* @perfcondget */
  bx_handletype handle,
  bx_int32 meas,                          
  bx_int32 offset,                         
  bx_perfcondtype prop, 
  bx_charptrtype *cond                 /* #RETURN "\"%s\"" */
);

CLI bx_errtype EXPORT BestXPerfCondDefaultSet( /* @perfconddefset */
  bx_handletype handle,
  bx_int32 meas,    
  bx_int32 offset                       
);

/****************************************************************************
  TRAN + COND properties ****************************************************
****************************************************************************/

CLI bx_errtype EXPORT BestXPerfTranCondDefaultSet( /* @perftranconddefset */
  bx_handletype handle,
  bx_int32 meas,                                 
  bx_int32 offset                               
);

CLI bx_errtype EXPORT BestXPerfDefaultSet(  /* @perfdefset */
  bx_handletype handle,
  bx_int32      meas
);

/****************************************************************************
  Actions *******************************************************************
****************************************************************************/

CLI bx_errtype EXPORT BestXPerfCtrRead(       /* @perfctrread */
  bx_handletype handle,
  bx_int32 meas,                          
  bx_int32 counter,                         
  bx_int32 *val                               /* #RETURN  "0x%08lx" */
);

CLI bx_errtype EXPORT BestXPerfProg(   /* @perfprog */
  bx_handletype handle,
  bx_int32 meas
);

CLI bx_errtype EXPORT BestXPerfRun(    /* @perfrun   */
  bx_handletype handle
);

CLI bx_errtype EXPORT BestXPerfStop(      /* @perfstop   */
  bx_handletype handle
);

CLI bx_errtype EXPORT BestXPerfUpdate(    /* @perfupdate */
  bx_handletype handle
);

/********************************************************************
  Performance programming *******************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXPerfProgMode(    /* @perfprogmode */
  bx_handletype  handle,
  bx_int32 SoftForce
);

CLI bx_errtype EXPORT BestXPerfRunMode(    /* @perfrunmode */
  bx_handletype  handle,
  bx_int32 SoftForce
);

CLI bx_errtype EXPORT BestXPerfIsInProgMode( /* @perfisinprogmode */
  bx_handletype handle,
  bx_int32 *ProgMode          /* #RETURN "%lu" */
);

#ifdef __cplusplus
}
#endif


#endif


